#version 330

struct Light
{
    vec3 position;
	vec3 intensity;
	float range;
};

uniform sampler2D specular_texture;
uniform vec3 camera_position;
uniform vec3 model_colour;
uniform vec3 ambient_colour;
uniform int apply_checker;

uniform Light lights[7];			//Has to be constant, set to max support.

in vec3 varying_position;
in vec3 varying_normal;
in vec2 varying_texcoord;

out vec4 fragment_colour;

float diffuseLight(vec3 lightPosition){
	vec3 L = normalize(lightPosition - varying_position);
	vec3 N = normalize(varying_normal);
	
	return max(dot(L,varying_normal), 0.0);
}

float specularLight(vec3 L, vec3 Rv, float specularIntensity){
	return pow(max(dot(L, Rv), 0.0), specularIntensity);
}

vec3 calculateChecker(){
	//Tyrone Checkerboard
	//vec2 uv = mod(varying_texcoord, 1);
	//bool use_A = (uv.x > 0.5) ^^ (uv.y > 0.5);
	//vec3 col = use_A ? vec3(0,0,0) : vec3(1,1,1);
	//return col;

	//Magical Checkerboard: Found at http://www.yaldex.com/open-gl/ch17lev1sec5.html
	//Modified a little
	vec2 uv = mod(varying_texcoord, 1);
	vec3 colOne = vec3(0,0,0);			//Black
	vec3 colTwo = vec3(1,1,1);			//White
	vec3 colAverage = mix(colOne, colTwo, 0.5);
	float maxBlurry = 1;
	vec3 colOut = vec3(0,1,0);			//Green (So can see if something went wrong)
	

	vec2 filterWidth = fwidth(varying_texcoord);	//Determine the width of the projection of one pixel into s-t space
	vec2 fuzz = filterWidth * maxBlurry;		//Determine the amount of fuzziness
	float fuzzMax = max(fuzz.s, fuzz.t);
	float filterMax = 1;				//The max size the checker will render to (1 has no obvious effect, set to 0.1 and you'll see)
	vec2 checkPos = fract(varying_texcoord);

	if (fuzzMax < filterMax){
		// If the filter width is small enough, compute the pattern color
	        vec2 p = smoothstep(vec2(0.5), fuzz + vec2(0.5), checkPos) +
	                (1.0 - smoothstep(vec2(0.0), fuzz, checkPos));
	
	        colOut = mix(colOne, colTwo, p.x * p.y + (1.0 - p.x) * (1.0 - p.y));
	
	        // Fade in the average color when we get close to the limit
	        colOut = mix(colOut, colAverage, smoothstep(0, filterMax, fuzzMax));
	} else {
		// Otherwise, use only the average color
		colOut = colAverage;
	}

	return colOut;

}

vec3 calculateLines(){
	vec2 uv = mod(varying_texcoord, 1);
	vec2 ab = step(0.9, uv);
    	bool use_A = ab.x > 0 || ab.y > 0;
	vec3 col = use_A ? vec3(0,0,0) : vec3(1,1,1);

	return col;	
}

void main(void)
{
	vec3 Il  = vec3(0, 0, 0);			//Intensity and colour of light visible to eye
	float Ia = 1;					//Ambient intensity
	vec3 Ka = ambient_colour;			//Ambient colour
	vec3 Kd = (model_colour);			//Diffuse colour of material	
	vec3 Ks = vec3(1,1,1);				//Specular colour


	if(apply_checker == 1){
		Kd = calculateChecker();
	}


	vec3 accumulatedLight = vec3(0,0,0);
	
	for(int lightIndex = 0; lightIndex < 7; lightIndex++){
	
		Il = lights[lightIndex].intensity;
	
		float d = distance(lights[lightIndex].position, varying_position);
		float Da = 1 - smoothstep(0, lights[lightIndex].range, d);
	
		vec3 L = normalize(lights[lightIndex].position - varying_position);
		vec3 N = normalize(varying_normal);
		
		vec3 V = normalize(camera_position - varying_position);
		vec3 Rv = reflect(-V, N);
		
		float I = diffuseLight(lights[lightIndex].position);

		float specularPower = texture( specular_texture, varying_texcoord).r * 16;	
		
		float specular = 0;
		if(specularPower > 0){
			specular = specularLight(L, Rv, specularPower);
		}

		accumulatedLight += (I * (Kd * Il + Ks * specular)) * Da;
	}
	
	fragment_colour = vec4(Ia * Ka + accumulatedLight, 1.0);

}
