package ncp.ica.server;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class ServerUDPThread extends Thread {

	Server server;
	DatagramSocket udpSocket = null;
	byte[] receiveData = new byte[1024];
    byte[] sendData = new byte[1024];
    
    boolean isRunning = true;
	
	ServerUDPThread(Server s, DatagramSocket udp){
		server = s;
		udpSocket = udp;
	}
	
	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}

	@Override
	public void run() {
		try{
			while(isRunning){
				//http://systembash.com/content/a-simple-java-udp-server-and-udp-client/
		        DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
		        udpSocket.receive(receivePacket);
		        
		        String message = new String( receivePacket.getData());
		        
		        String[] values = message.split(":");
		       
		        
		        //Wait till the clientData has been setup.
		        //Causes an error due to the client sending UDP as soon as they send TCP "JOIN"
	        	while(server.clientData.get(values[1]) == null){
	        		try {
	        			sleep(100);
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
	        	}
		        
		        if(values[0].equals("MOVE")){
		        	server.clientData.get(values[1]).setXPos(values[2]);
		        	server.clientData.get(values[1]).setYPos(values[3]);
		     
		        } else if(values[0].equals("DIR")){
		        	server.clientData.get(values[1]).setDirection(values[2]);
		        }
		
		        //Add the client to the UDP list
		        if(!server.knownClientPortUDP.contains(receivePacket.getPort())){
		        	server.knownClientPortUDP.add(receivePacket.getPort());
		        	server.clientData.get(values[1]).udpSocket = receivePacket.getPort();
		        }
		
		        //Forward the message to all known clients.
		        sendUDP(message);
		        
				super.run();
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public void sendUDP(String message){
        for(Integer port : server.knownClientPortUDP){
    		try{
    		    //DatagramSocket clientSocket = new DatagramSocket();
    		    InetAddress IPAddress = InetAddress.getByName("localhost");
    		    
    		    System.out.println("Sending: " + message + " TO: " + port);
    		   
    		    sendData = message.getBytes();
    		    DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, IPAddress, port);
    		    udpSocket.send(sendPacket);
    		    
    		    //clientSocket.close();
    		} catch (IOException e) {
    			// TODO Auto-generated catch block
    			e.printStackTrace();
    		}
        }
        
	}
	
}
