package ncp.ica.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Map;

import ncp.ica.Status;

public class ServerTCPThread extends Thread {

	// TCP Info
	Server server;
	Socket tcpSocket = null;
	ClientData client;
	
	boolean isRunning = true;

	ServerTCPThread(Server s, Socket tcp/*, ClientData c*/) {
		tcpSocket = tcp;
		server = s;
		client = new ClientData(server, tcpSocket);
		client.setClientThread(this);
	}

	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}

	@Override
	public void run() {
		try {
			while (isRunning) {

				String message = readTCP(tcpSocket);
				
				//Remove the user if the message is null. Only seems to happen on Linux?
				if(message == null){
					closeMyUser();
					break;
				}
				
				String[] values = message.split(":");
				
				//For message type, check values[0]
				if (values[0].equals("JOIN")) {
					//values[1] == User ID
					//values[2] == Username
					
					client.clientID = values[1];
					client.clientUsername = values[2];
					Boolean isOldPlayer = false;
					String oldPlayerID = null;
					
					//Check if the username has joined before
					for (Map.Entry<String, ClientData> userInfo : server.clientData.entrySet()) {
						if(userInfo.getValue().clientUsername.equals(client.clientUsername)){
							isOldPlayer = true;
							server.clientData.put(client.clientID, userInfo.getValue());
							server.clientData.get(client.clientID).tcpSocket = client.tcpSocket;
							server.clientData.get(client.clientID).myServerThread.isRunning = true;
							server.clientData.get(client.clientID).isOnline = true;
							server.clientData.get(client.clientID).inGame = false;
							//server.clientData.get(client.clientID).myServerThread.start();
							break;
						}
					}
					if(isOldPlayer){
						server.clientData.remove(oldPlayerID);
						server.clientData.get(client.clientID).sendStats();
					} else {
						server.clientData.put(client.clientID, client);	
					}
					
					for (Map.Entry<String, ClientData> userInfo : server.clientData.entrySet()) {
						if (userInfo.getKey().equals(values[1]) || userInfo.getValue().clientUsername.equals(values[2]) 
								|| !userInfo.getValue().isOnline || userInfo.getValue().inGame) {
							continue;
						}
						//sendTCP("JOIN:" + userInfo.getKey() + ":" + userInfo.getValue().clientUsername + ":", values[1]);
						sendTCP("JOIN_CUR:" + userInfo.getKey() + ":" + userInfo.getValue().clientUsername + ":" +
								userInfo.getValue().getXPos() + ":" + userInfo.getValue().getYPos() + ":" + userInfo.getValue().getDirection() + ":", values[1]);

						
						
						//server.udpThread.sendUDP("MOVE:" + userInfo.getKey() + ":" + userInfo.getValue().getXPos() + ":" + userInfo.getValue().getYPos() + ":");
						//server.udpThread.sendUDP("DIR:" + userInfo.getKey() + ":" + userInfo.getValue().getDirection() + ":");
					}
					
					sendTCP(message);
					
					
				} else if (values[0].equals("CHALLENGE")) {
					//values[1] == User ID Sending Challange
					//values[2] == User ID that should get the request
					if(server.clientData.get(values[2]).clientStatus.equals("READY")){
						System.out.println("PLAYER STATUS IS: " + server.clientData.get(values[2]).clientStatus);
						sendTCP(message, values[2]);
						client.currentChallenger = values[2];
					} else {
						sendTCP("CHALLENGE_REPLY:" + values[2] + ":" + values[1] + ":false:", values[1]);
					}
				} else if (values[0].equals("CHALLENGE_REPLY")) {
					//values[1] == User ID responding to challenge
					//values[2] == User ID that started the challenge
					//values[3] == Bool: true = game on, false = no game
					sendTCP(message, values[2]);

					//sendTCP("IN_CHALLENGE:" + values[1] + values[2]);
					if(values[3].equals("true")){
						client.currentChallenger = values[1];
						
						Integer gameNumber = server.setupGame(values[2], client.currentChallenger);
						
/*						sendTCP("REMOVE:" + values[1] + ":");
						sendTCP("REMOVE:" + values[2] + ":");*/
						
						sendTCP("GAME_STARTED:" + gameNumber.toString() + ":", values[1]);
						sendTCP("GAME_STARTED:" + gameNumber.toString() + ":", values[2]);
						
					}
					
				} else if (values[0].equals("NAME")){
					//values[1] == User ID
					//values[2] == New username
					for (Map.Entry<String, ClientData> userInfo : server.clientData.entrySet()) {
						if (userInfo.getKey().equals(values[1])) {
							userInfo.getValue().clientUsername = values[2];
							break;
						}
					}
					sendTCP(message);

				} else if (values[0].equals("MESSAGE")){
					//values[1] == User ID
					//values[2] == Challenger ID
					//values[3] == Text Message
					sendTCP(message, values[2]);
				} else if(values[0].equals("SHAPE_CHOICE")){
					//values[1] == User ID
					//values[2] == Game ID
					//values[3] == Shape Picked
					
					RPSGame game = server.clientGames.get(Integer.parseInt(values[2]));
					game.setChoice(values[1], values[3]);
					
					
				} else if (values[0].equals("REJOIN")){
					//values[1] == User ID
					//values[2] == Username
					//values[3] == X pos
					//values[4] == Y pos
					//values[5] == Direction
					sendTCP(message + server.clientData.get(values[1]).getXPos() + ":" + server.clientData.get(values[1]).getYPos() + ":" +
							server.clientData.get(values[1]).getDirection() + ":" );
				} else if (values[0].equals("STATUS")){
					//values[1] == User ID
					//values[2] == Client Status
					server.clientData.get(values[1]).clientStatus = values[2];
					sendTCP(message);
				} else {
					System.out.println("Didnt do anything with: " + message);
				}
			}
			
		} catch (IOException e) {
			//e.printStackTrace();
			
			closeMyUser();
		}

		super.run();
	}

	public void sendTCP(String message) {

		for (Map.Entry<String, ClientData> connectedClient : server.clientData.entrySet()) {
			
			if(connectedClient.getValue().isOnline){	
				try {
	
					System.out.println("SERVER: Sent Data TCP");
	
					OutputStream textOutput;
					textOutput = connectedClient.getValue().tcpSocket.getOutputStream();
					PrintWriter writer = new PrintWriter(textOutput, true);
					writer.println(message);
	
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	public void sendTCP(String message, String clientID) {
		
		if(server.clientData.get(clientID).isOnline){
			Socket sock = server.clientData.get(clientID).tcpSocket;

			try {
				System.out.println(message + this.toString());
				
				OutputStream textOutput;
				textOutput = sock.getOutputStream();
				PrintWriter writer = new PrintWriter(textOutput, true);
				writer.println(message);
	
			} catch (IOException e) {
				System.out.println("Socket seems to be closed for: " + clientID + " - Socket: " + server.clientData.get(clientID).tcpSocket);
			}
		}

	}

	private String readTCP(Socket socket) throws IOException {
		// Read the data passed through
		BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
		String message = br.readLine();

		System.out.println("SERVER RECIEVED A " + message + " COMMAND.");

		return message;
	}
	
	private void closeMyUser(){
		System.out.println("Removing user (TCP Disconnection?)");
		System.out.println("Could be due to null messages (Linux) OR TCP socket error.");

		if(client.inGame){
			server.clientData.get(client.currentChallenger).myServerThread.sendTCP("CLOSE:", client.currentChallenger);
			server.clientData.get(client.currentChallenger).myServerThread.sendTCP("STATUS:" + client.currentChallenger + ":" + Status.READY.toString() + ":");
			server.clientData.get(client.currentChallenger).clientStatus = Status.READY.toString();
			client.currentChallenger = null;
		}
		
		isRunning = false;
		client.isOnline = false;
		
		for(Map.Entry<String, ClientData> entry : server.clientData.entrySet()){
			if(entry.getValue().clientID.equals(client.clientID) || !entry.getValue().isOnline){
				continue;
			}
			sendTCP("REMOVE:" + client.clientID + ":", entry.getValue().clientID);
		}
		
		client.clientQuit();
								
		System.out.println("Removed clientID: " + client.clientID + " on port: " + client.tcpSocket.getPort());
	}

}
