package ncp.ica.server;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Server extends Thread{
	
	//Sockets
	ServerSocket tcpSocket = null;
	DatagramSocket udpSocket = null;
	
	Boolean isRunning = true;
	ServerUDPThread udpThread;
	
	
	Map<String, ClientData> clientData = new HashMap<String, ClientData>();
	//Map<Socket, ServerTCPThread> tcpThreads = new HashMap<Socket, ServerTCPThread>();
	//Map<String, Socket> knownClientAddrTCP = new HashMap<String, Socket>();
	//Map<String, String> knownClients = new HashMap<String, String>();	
	
	
	//Keep a list of all UDP ports, ideally should close this when TCP closes.
	ArrayList<Integer> knownClientPortUDP = new ArrayList<Integer>();
	
	//Hold a list of all the games that are running. <Game Number, Game Class>
	Map<Integer, RPSGame> clientGames = new HashMap<Integer, RPSGame>();
	
	

	Server(){
		
		try {
			//This will find a free port and assign it. Avoiding setting ports to avoid clashes.
			//tcpSocket = new ServerSocket(0);
			//udpSocket = new DatagramSocket(0);
			
			tcpSocket = new ServerSocket(6060, 100);		//Port, Max Backlog
			udpSocket = new DatagramSocket(6061);
			
			System.out.println("SERVER STARTED");
			System.out.println(tcpSocket.getLocalPort());
			System.out.println(udpSocket.getLocalPort());
			
			//tcpThread = new ServerThread(this, tcpSocket);
			//tcpThread.start();
			
			udpThread = new ServerUDPThread(this, udpSocket);
			udpThread.start();
			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public static void main(String[] args) {
		Server myServer = new Server();
		myServer.start();
	}

	@Override
	public void run() {
		while(isRunning){
			try {
				
				//Listen for new connection requests and create a new thread when we see one.
				Socket socket = tcpSocket.accept();
				//tcpThreads.add(new ServerThread(this, socket));
				
				ServerTCPThread newThread = new ServerTCPThread(this, socket);
				newThread.start();
				
				//clientData.put("UNDEFINED", new ClientData(this, socket));
				//tcpThreads.put(socket, newThread);
				//newThread.start();
				
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
	}
	
	public synchronized Integer setupGame(String playerOneID, String playerTwoID){
		
		//Socket playerOneSock = clientData.get(playerOneID).tcpSocket;
		//Socket playerTwoSock = clientData.get(playerTwoID).tcpSocket;
		
		ServerTCPThread playerOneThread = clientData.get(playerOneID).myServerThread;
		ServerTCPThread playerTwoThread = clientData.get(playerTwoID).myServerThread;
		
		Integer gameNumber = clientGames.size();
		
		System.out.println("P1ID: " + playerOneID);
		System.out.println("P2ID: " + playerTwoID);
		System.out.println("P1Thread: " + playerOneThread);
		System.out.println("P2Thread: " + playerTwoThread);
		System.out.println("GameNum: " + gameNumber);
		
		clientGames.put(gameNumber, new RPSGame(playerOneID, playerTwoID, playerOneThread, playerTwoThread, gameNumber, this));
		

		
		
		clientGames.get(gameNumber).start();
		
		return gameNumber;
	}
	
	public synchronized void closeGame(Integer gameNumber){
		
		RPSGame game = clientGames.get(gameNumber);
		
/*		game.playerOneThread.sendTCP("REJOIN:" + game.playerOneID + ":" + clientData.get(game.playerOneID).clientUsername + ":" + 
				clientData.get(game.playerOneID).getXPos() + ":" + 
				clientData.get(game.playerOneID).getYPos() + ":" +
				clientData.get(game.playerOneID).getDirection() + ":" );
		game.playerTwoThread.sendTCP("REJOIN:" + game.playerTwoID + ":" + clientData.get(game.playerTwoID).clientUsername + ":" + 
				clientData.get(game.playerTwoID).getXPos() + ":" + 
				clientData.get(game.playerTwoID).getYPos() + ":" +
				clientData.get(game.playerTwoID).getDirection() + ":" );*/
		
		game.gameOn = false;
		clientGames.remove(gameNumber);
		
		clientData.get(game.playerOneID).inGame = false;
		clientData.get(game.playerTwoID).inGame = false;
		
	}
	
/*	public void sendUDP(String message){
        for(Integer port : knownClientPortUDP){
    		try{
    		    //DatagramSocket clientSocket = new DatagramSocket();
    		    InetAddress IPAddress = InetAddress.getByName("localhost");
    		    
    		    System.out.println("Sending: " + message + " TO: " + port);
    		   
    		    udpThread.sendData = message.getBytes();
    		    DatagramPacket sendPacket = new DatagramPacket(udpThread.sendData, udpThread.sendData.length, IPAddress, port);
    		    udpSocket.send(sendPacket);
    		    
    		    //clientSocket.close();
    		} catch (IOException e) {
    			// TODO Auto-generated catch block
    			e.printStackTrace();
    		}
        }
        
	}*/

}
