package ncp.ica.server;

import java.util.ArrayList;
import java.util.List;

public class RPSGame extends Thread {

	String playerOneID;
	String playerTwoID;
	
	ServerTCPThread playerOneThread;
	ServerTCPThread playerTwoThread;
	
	Boolean playerOneStatus = null;
	Boolean playerTwoStatus = null;
	
	String playerOneChoice = null;
	String playerTwoChoice = null;
	
	Integer myGameNumber = null;
	Server server;
	boolean gameOn = true;
	
	RPSGame(String playerOneID, String playerTwoID, ServerTCPThread playerOneThread, ServerTCPThread playerTwoThread, Integer myGameNumber, Server server){
		this.playerOneID = playerOneID;
		this.playerTwoID = playerTwoID;
		
		this.playerOneThread = playerOneThread;
		this.playerTwoThread = playerTwoThread;
		
		this.myGameNumber = myGameNumber;
		this.server = server;
		
		server.clientData.get(playerOneID).inGame = true;
		server.clientData.get(playerTwoID).inGame = true;
		
		//Find how many games player one has won against two.
		if(server.clientData.get(playerOneID).userHistory.get(playerTwoID) != null){
			List<Boolean> previousGames = server.clientData.get(playerOneID).userHistory.get(playerTwoID);
			Integer timesWon = 0;

			for(Boolean didWin : previousGames){
				if(didWin){
					timesWon += 1;
				}
			}
			
			server.clientData.get(playerOneID).myServerThread.sendTCP("GAME_MESSAGE:" + "You have won " + timesWon.toString() + "/" +
			previousGames.size() + " games against " + server.clientData.get(playerTwoID).clientUsername + ":", playerOneID);
			
		} else {
			server.clientData.get(playerOneID).myServerThread.sendTCP("GAME_MESSAGE:" + "This is your first game against " + 
													server.clientData.get(playerTwoID).clientUsername + ":", playerOneID);
		}
		
		//Find how many games player two has won against one.
		if(server.clientData.get(playerTwoID).userHistory.get(playerOneID) != null){
			List<Boolean> previousGames = server.clientData.get(playerTwoID).userHistory.get(playerOneID);
			Integer timesWon = 0;

			for(Boolean didWin : previousGames){
				if(didWin){
					timesWon += 1;
				}
			}
			
			server.clientData.get(playerTwoID).myServerThread.sendTCP("GAME_MESSAGE:" + "You have won " + timesWon.toString() + "/" +
			previousGames.size() + " games against " + server.clientData.get(playerOneID).clientUsername + ":", playerTwoID);
			
		} else {
			server.clientData.get(playerTwoID).myServerThread.sendTCP("GAME_MESSAGE:" + "This is your first game against " + 
													server.clientData.get(playerOneID).clientUsername + ":", playerTwoID);
		}
		
	}
	
	public void setChoice(String playerID, String shape){
		if(playerOneID.equals(playerID)){
			playerOneChoice = shape;
		} else if(playerTwoID.equals(playerID)){
			playerTwoChoice = shape;
		}
	}
	
	public void checkWinner(String myShape, String challengerShape){
		
		//userInterface.setOpponentShape(challengerShape);
		if(myShape.equals(challengerShape)){
			if(myShape.equalsIgnoreCase("cheat")){
				server.clientData.get(playerOneID).usedCheat();
				server.clientData.get(playerTwoID).usedCheat();
				playerOneStatus = true;
				playerTwoStatus = true;
			} else {
				playerOneStatus = false;
				playerTwoStatus = false;
			}
		} else if(myShape.equalsIgnoreCase("cheat") || challengerShape.equalsIgnoreCase("cheat")){
			if(myShape.equalsIgnoreCase("cheat")){
				server.clientData.get(playerOneID).usedCheat();
				playerOneStatus = true;
				playerTwoStatus = false;
			} else {
				server.clientData.get(playerTwoID).usedCheat();
				playerTwoStatus = true;
				playerOneStatus = false;
			}
		} else {
			if(playerOneChoice.equalsIgnoreCase("scissors")){
				if(playerTwoChoice.equalsIgnoreCase("paper")){
					playerOneStatus = true;
					//LOSS
				} else if(playerTwoChoice.equalsIgnoreCase("rock")){
					playerOneStatus = false;
					//WIN
				}
			} else if(playerOneChoice.equalsIgnoreCase("paper")){
				if(playerTwoChoice.equalsIgnoreCase("rock")){
					playerOneStatus = true;
					//LOSS
				} else if(playerTwoChoice.equalsIgnoreCase("scissors")){
					playerOneStatus = false;
					//WIN
				}
			} else if(playerOneChoice.equalsIgnoreCase("rock")){
				if(playerTwoChoice.equalsIgnoreCase("scissors")){
					playerOneStatus = true;
					//LOSS
				} else if(playerTwoChoice.equalsIgnoreCase("paper")){
					playerOneStatus = false;
					//WIN
				}
			}
			
			//Set player two to be opposite
			playerTwoStatus = !playerOneStatus;
		}
				
	}
	
	@SuppressWarnings("static-access")
	@Override
	public void run() {
		while(gameOn){
			//System.out.println("Checking...");
			if(playerOneChoice != null && playerTwoChoice != null){
				System.out.println("BOTH CHOICES ARE NO LONGER NULL");
				
				checkWinner(playerOneChoice, playerTwoChoice);
				
				//System.out.println("GAME_RESULT:" + playerOneStatus.toString() + ":" + "," + playerOneID + ":");
				
				//System.out.println(playerOneThread.toString());
				
				playerOneThread.sendTCP("GAME_RESULT:" + playerOneStatus.toString() + ":" + playerTwoChoice + ":", playerOneID);
				playerTwoThread.sendTCP("GAME_RESULT:" + playerTwoStatus.toString() + ":" + playerOneChoice + ":", playerTwoID);
				
				//Add win or loss for player one and two.
				if(playerOneStatus){
					server.clientData.get(playerOneID).addWin();
				} else {
					server.clientData.get(playerOneID).addLoss();
				}
				if(playerTwoStatus){
					server.clientData.get(playerTwoID).addWin();
				} else {
					server.clientData.get(playerTwoID).addLoss();
				}
				
				//Check to see if player one has a record of playing with two.
				if(server.clientData.get(playerOneID).userHistory.get(playerTwoID) == null){
					//Setup player one
					List<Boolean> newList = new ArrayList<Boolean>();
					newList.add(playerOneStatus);
					server.clientData.get(playerOneID).userHistory.put(playerTwoID, newList);
				} else {
					//We have played this user before, make a copy of the list, add to it and set it to the new list.
					List<Boolean> copyList = server.clientData.get(playerOneID).userHistory.get(playerTwoID);
					copyList.add(playerOneStatus);
					server.clientData.get(playerOneID).userHistory.put(playerTwoID, copyList);
				}
				
				//Do the above again but for player two.
				if(server.clientData.get(playerTwoID).userHistory.get(playerOneID) == null){
					//Setup player one
					List<Boolean> newList = new ArrayList<Boolean>();
					newList.add(playerTwoStatus);
					server.clientData.get(playerTwoID).userHistory.put(playerOneID, newList);
				} else {
					//We have played this user before, make a copy of the list, add to it and set it to the new list.
					List<Boolean> copyList = server.clientData.get(playerTwoID).userHistory.get(playerOneID);
					copyList.add(playerTwoStatus);
					server.clientData.get(playerTwoID).userHistory.put(playerOneID, copyList);
				}
				
				//Reset choices to be null.
				playerOneChoice = null;
				playerTwoChoice = null;
				playerOneStatus = null;
				playerTwoStatus = null;
				
				//Send clients user stats
				server.clientData.get(playerOneID).sendStats();
				server.clientData.get(playerTwoID).sendStats();
				
				//Doesn't seem like there is ever more than one game played so rejoin the clients and stop this thread.
				server.closeGame(myGameNumber);
			}
			try {
				this.sleep(100);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		super.run();
	}

	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}

	
	
}
