package ncp.ica.server;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClientData {
	Server server;
	Socket tcpSocket;
	Integer udpSocket;
	ServerTCPThread myServerThread;
	
	String clientID;
	String clientUsername;
	String currentChallenger;
	String xPos;
	String yPos;
	String direction = "0";
	String clientStatus = "READY";
	Integer wins = 0;
	Integer losses = 0;
	Integer score = 0;
	boolean isOnline;
	boolean inGame;
	Map<String, List<Boolean>> userHistory = new HashMap<String, List<Boolean>>();
	
	
	
	ClientData(Server server, Socket tcpSocket){
		this.server = server;
		this.tcpSocket = tcpSocket;
		isOnline = true;
		inGame = false;
		
		//myServerThread = new ServerTCPThread(server, tcpSocket, this);
		//myServerThread.start();
		
	}
	
	public synchronized void sendStats(){
		myServerThread.sendTCP("USER_DATA:" + wins.toString() + ":" + losses.toString() + ":" + score.toString() + ":", clientID);
	}
	
	public void setClientThread(ServerTCPThread thread){
		myServerThread = thread;
	}
	
	public synchronized void setXPos(String x){
		xPos = x;
	}
	
	public synchronized void setYPos(String y){
		yPos = y;
	}
	
	public synchronized void setDirection(String dirRads){
		direction = dirRads;
	}
	
	public synchronized String getXPos(){
		return xPos;
	}
	
	public synchronized String getYPos(){
		return yPos;
	}
	
	public synchronized String getDirection(){
		return direction;
	}
	
	public synchronized void addWin(){
		wins += 1;
		score += 20;
	}
	
	public synchronized void usedCheat(){
		score -= 60;
	}
	
	public synchronized void addLoss(){
		losses += 1;
		score += -5;
	}
	
	public void clientQuit(){
		try {
			isOnline = false;
			myServerThread.isRunning = false;
			tcpSocket.close();
			server.knownClientPortUDP.remove(udpSocket);
			//Keep rest of data in case of rejoin?
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}

}
