package ncp.ica.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

public class ClientUDPThread extends Thread {

	Client myClient;
	DatagramSocket udpSocket = null;
	byte[] receiveData = new byte[1024];
    byte[] sendData = new byte[1024];
    boolean isRunning = true;
    
    ClientUDPThread(Client c, DatagramSocket sock){
    	myClient = c;
    	udpSocket = sock;
    }
    
	@Override
	public void run() {
		while(isRunning){
			checkUDP();
			super.run();
		}		
	}

	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}

	public void checkUDP(){
		//System.out.println("CHECKING UDP");
		try{
	        DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
	        udpSocket.receive(receivePacket);
	        
	        String message = new String( receivePacket.getData());
	        //System.out.println("CLIENT RECEIVED: " + message);
	        
	        String[] values = message.split(":");
	        
	        if(values[0].equals("MOVE")){
	        	myClient.userInterface.setLocation(values[1], Integer.parseInt(values[2]), Integer.parseInt(values[3]));
	        	//userInterface.setLocation(id, x, y)
	        } else if(values[0].equals("DIR")){
	        	myClient.userInterface.setDirection(values[1], Double.parseDouble(values[2]));
	        }
	        
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
}
