package ncp.ica.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.net.Socket;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

import ncp.ica.Status;

public class ClientTCPThread extends Thread {

	Client client;
	
	//TCP Info
	Socket tcpSocket = null;
    
	boolean threadRunning = true;
	Integer myGameID = null;
	
	ObjectOutputStream outputStream;
	ObjectInputStream inputStream;
	
	ClientTCPThread(Client c, Socket tcp){
		tcpSocket = tcp;
		client = c;
	}
	
	public static void main(String[] args) {

	}

	@Override
	public void run() {
			
		try {
			while(threadRunning){		
				InputStream textInput = tcpSocket.getInputStream();				//Create the input stream
				Reader inputReader = new InputStreamReader(textInput);			//The reader that will read the stream
				BufferedReader inputBuffer = new BufferedReader(inputReader);	//Buffered reader so can read each line.
				String clientData = "";
				
				while(((clientData = inputBuffer.readLine()) != null) && threadRunning){
					
					//System.out.println("CLIENT: Got Data TCP");
					
					//System.out.println(clientData);
					
			        String[] values = clientData.split(":");
			        
			        if(values[0].equals("JOIN")){
			        	//values[1] == User ID
			        	//values[2] == Username
			        	if(!(client.myUserID.equals(values[1]) && client.myUsername.equals(values[2]))){
			        		client.userInterface.addUser(values[1], values[2]);
			        		
			        	}
			        } else if(values[0].equals("JOIN_CUR")){
			        	//values[1] == User ID
			        	//values[2] == Username
			        	//values[3] == X pos
			        	//values[4] == Y pos
			        	//values[5] == Direction			        	
			        	if(!(client.myUserID.equals(values[1]) && client.myUsername.equals(values[2]))){
			        		client.userInterface.addUser(values[1], values[2]);
			        		client.userInterface.setLocation(values[1], 
			        				Integer.parseInt(values[3]), Integer.parseInt(values[4]));
			        		client.userInterface.setDirection(values[1], Double.parseDouble(values[5]));
			        	}
			        } else if(values[0].equals("CHALLENGE")){
			        	//values[1] == Requester ID
			        	//values[2] == My ID
			        	
			        	
			        	client.setStatus(Status.WAITING);
			        	
			        	
			        	//Got this from http://stackoverflow.com/questions/1164301/how-do-i-call-some-blocking-method-with-a-timeout-in-java
			        	//I think I know how it works but I couldn't think of any way round it.
			        	//I was going to make a thread to track time and stuff but seemed a lot more work than this.
			        	final String userID = values[1];
			        	
			        	ExecutorService executor = Executors.newCachedThreadPool();
			        	Callable<Boolean> task = new Callable<Boolean>() {
			        	   public Boolean call() {
			        	      return client.userInterface.displayChallenge(userID);
			        	   }
			        	};
			        	Future<Boolean> future = executor.submit(task);
			        	
			        	Boolean wantsToPlay = null;
			        	try{
			        		wantsToPlay = future.get(5, TimeUnit.SECONDS);

				    		if(wantsToPlay){
				    			client.challengerID = values[1];
				    			client.userInterface.startGame();
				    			client.sendTCP("CHALLENGE_REPLY:" + client.myUserID + ":" + values[1] + ":true:");
				    			client.setStatus(Status.PLAYING);
				    		} else {
				    			client.userInterface.cancelGame();
				    			client.sendTCP("CHALLENGE_REPLY:" + client.myUserID + ":" + values[1] + ":false:");
				    			client.setStatus(Status.READY);
				    		}
			        		
			        		
			        	} catch (TimeoutException ex) {
			        		   // handle the timeout
			        	} catch (InterruptedException e) {
			        		   // handle the interrupts
			        	} catch (ExecutionException e) {
			        		   // handle other exceptions
			        	} finally {
			        		if(wantsToPlay == null){
				    			client.userInterface.cancelGame();
				    			client.sendTCP("CHALLENGE_REPLY:" + client.myUserID + ":" + values[1] + ":false:");
				    			client.setStatus(Status.READY);
			        		}
			        	}
			        	
			        	
			        	//Boolean wantsToPlay = client.userInterface.displayChallenge(values[1]);
			        	
			        	System.out.println("WTP: " + wantsToPlay);
			        	
			        } else if(values[0].equals("CHALLENGE_REPLY")){
						//values[1] == User ID responding to challenge
						//values[2] == User ID that started the challenge
						//values[3] == Bool: true = game on, false = no game
			        	if(values[3].equals("true")){
			        		client.challengerID = values[1];
			        		client.userInterface.startGame();
			        		client.setStatus(Status.PLAYING);
			        	} else {
			        		client.userInterface.cancelGame();
			        		client.setStatus(Status.READY);
			        	}
			        	
			        	//sendTCP("CHALLENGE_REPLY:" + myUserID + ":" + id + ":CANCEL:");
			        } else if(values[0].equals("GAME_STARTED")){
			        	//values[1] == Game ID
			        	myGameID = Integer.parseInt(values[1]);
			        } else if(values[0].equals("NAME")){
			        	//values[1] == User ID
			        	//values[2] == New username
			        	client.userInterface.setUsername(values[1], values[2]);
			        } else if (values[0].equals("MESSAGE")){
						//values[1] == User ID
						//values[2] == Challenger ID
						//values[3] == Text Message
			        	client.userInterface.addChat(values[3]);
			        } else if (values[0].equals("GAME_RESULT")){
			        	//values[1] == Bool: true = won, false = loss/tie
			        	//values[2] == Opponents choice
			        	System.out.println("GAME_RESULT MESSAGE: " + values[1]);
			        	
			        	client.userInterface.setOpponentShape(values[2]);
			        	
						if(values[1].equalsIgnoreCase("true")){
							client.userInterface.revealWinner(true);
						} else {
							client.userInterface.revealWinner(false);
						}
						
						client.challengerID = null;
						client.setStatus(Status.READY);
						
			        } else if (values[0].equals("CLOSE")){
			        	client.userInterface.cancelGame();
			        	client.challengerID = null;			        	
			        } else if(values[0].equals("REMOVE")){
			        	//values[1] == User ID
			        	if(values[1].equals(client.myUserID))
			        		continue;
			        	client.userInterface.removeUser(values[1]);
			        } else if(values[0].equals("REJOIN")){
						//values[1] == User ID
						//values[2] == Username
						//values[3] == X pos
						//values[4] == Y pos
						//values[5] == Direction
			        	if(values[1].equals(client.myUserID))
			        		continue;
			        	client.userInterface.addUser(values[1], values[2]);
			        	client.userInterface.setLocation(values[1], Integer.parseInt(values[3]), Integer.parseInt(values[4]));
			        	client.userInterface.setDirection(values[1], Double.parseDouble(values[5]));
			        } else if (values[0].equals("STATUS")){
			        	//values[1] == User ID
			        	//values[2] == Status Enum
			        	client.userInterface.setPlayerStatus(values[1], Status.valueOf(values[2]));
			        } else if(values[0].equals("GAME_MESSAGE")){
			        	//values[1] == message
			        	client.userInterface.setGameMessage(values[1]);
			        } else if(values[0].equals("USER_DATA")){
			        	client.userInterface.setWins(Integer.parseInt(values[1]));
			        	client.userInterface.setLosses(Integer.parseInt(values[2]));
			        	client.userInterface.setScore(Integer.parseInt(values[3]));
			        }					
				}				
			}
			threadRunning = false;
		} catch (IOException e) {
			e.printStackTrace();
		}
		
	}

}
