package ncp.ica.client;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;

import ncp.ica.ClientProxy;
import ncp.ica.ClientUI;
import ncp.ica.Status;

public class Client implements ClientProxy {
	
	ClientUI userInterface;
	ClientTCPThread myTCPThread;
	ClientUDPThread myUDPThread;
	
	String myUsername;
	String myUserID;
	String challengerID;
	String challengerShape = null;
	
	static boolean isConnected = false;
	
	//TCP Info
	Socket tcpSocket = null;
	
	//UDP Info
	DatagramSocket udpSocket = null;
	byte[] receiveData = new byte[1024];
    byte[] sendData = new byte[1024];
    
    //Hard coded ports for server
    int udpServerPort = 6061;
    int tcpServerPort = 6060;

	Client(){
		userInterface = new ClientUI(this);
		
		userInterface.addHandShape("Cheat", "cheat.png");
		//userInterface.addStat("wins", 0);
		//userInterface.addStat("losses", 0);
		userInterface.setScore(0);
		userInterface.displayStats();
		
/*		try {
			
			//This will find a free port and assign it. Avoiding setting ports to avoid clashes.
			//tcpSocket = new Socket(InetAddress.getLocalHost(), 6060);	//Bind to a random local port
			//udpSocket = new DatagramSocket(0);							//Bind to a random local port
			
			//System.out.println("ClientThread TCP Port: " + tcpSocket.getLocalPort());
			//System.out.println("ClientThread UDP Port: " + udpSocket.getLocalPort());	
			
			
		} catch (IOException e) {
			System.out.println("Connection could not be made." + e);
			//e.printStackTrace();
		}*/
		
		
		//System.out.println("New Client");
		
	}
	
	
	private void sendUDP(String message){
		try{
		    //DatagramSocket clientSocket = new DatagramSocket();
		    InetAddress IPAddress = InetAddress.getByName("localhost");
		   
		    sendData = message.getBytes();
		    DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, IPAddress, udpServerPort);
		    udpSocket.send(sendPacket);
		    
		    
		    System.out.println("CLIENT SENT UDP: " + message);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void sendTCP(String message){
		//System.out.println("Trying to send: " + message);
		OutputStream textOutput;
		try {
			
			textOutput = tcpSocket.getOutputStream();
			PrintWriter writer = new PrintWriter(textOutput, true);
			writer.println(message);
			
			System.out.println("CLIENT SENT TCP: " + message);
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public boolean makeConnection(){
			try{
				tcpSocket = new Socket(InetAddress.getLocalHost(), 6060);	//Bind to a random local port
				udpSocket = new DatagramSocket(0);							//Bind to a random local port
						
				System.out.println("ClientThread TCP Port: " + tcpSocket.getLocalPort());
				System.out.println("ClientThread UDP Port: " + udpSocket.getLocalPort());	
				
				myTCPThread = new ClientTCPThread(this, tcpSocket);
				myTCPThread.start();
				
				myUDPThread = new ClientUDPThread(this, udpSocket);
				myUDPThread.start();
				
				isConnected = true;
				return isConnected;
			} catch (IOException e) {
				System.out.println("Connection could not be made." + e);
				return isConnected;
				//e.printStackTrace();
			}				
	}
	

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		Client myClient = new Client();
/*		Client myClientb = new Client();
		Client myClientc = new Client();
		Client myClientd = new Client();*/

	}

	@Override
	public void setDirection(double rads) {
		// TODO Auto-generated method stub
		//"DIR::myID:Value"
		sendUDP("DIR:"  + myUserID + ":" + rads + ":");
	}

	@Override
	public void moveChar(int x, int y) {
		sendUDP("MOVE:" + myUserID + ":" + x + ":" + y + ":");
	}

	@Override
	public void join(String id, String username) {		
		// TODO Auto-generated method stub
		

		while(!makeConnection()){
			//If a connection isn't made, don't do anything and try again.
		}
		
		myUsername = username;
		myUserID = id;
		sendTCP("JOIN:" + id + ":" + username + ":");
		setStatus(Status.READY);
		
		
	}

	@Override
	public void challenge(String id) {
		// TODO Auto-generated method stub
		//challangerID = id;
		sendTCP("CHALLENGE:" + myUserID + ":" + id + ":");
		setStatus(Status.WAITING);
		//userInterface.setPlayerStatus(Status.WAITING);
	}

	@Override
	public void sendChat(String message) {
		// TODO Auto-generated method stub
		
		
		sendTCP("MESSAGE:" + myUserID + ":" + challengerID + ":" + message + ":");
		
		//userInterface.

	}

	@Override
	public void changeName(String username) {
		// TODO Auto-generated method stub
		sendTCP("NAME:" + myUserID + ":" + username + ":");

	}

	@Override
	public boolean makeShape(String shape) {
		// TODO Auto-generated method stub
		
		//userInterface.cancelGame();
		
		sendTCP("SHAPE_CHOICE:" + myUserID + ":" + myTCPThread.myGameID + ":" + shape + ":");
		
		return false;
	}
	
	public void setStatus(Status s){
		userInterface.setPlayerStatus(s);
		sendTCP("STATUS:" + myUserID + ":" + s.toString() + ":");
	}
	
	

}
