package ncp.ica;

import ncp.ica.ui.RPSChallenge;

public class ClientUI {
	
	RPSChallenge rpsc;
	
	public ClientUI(ClientProxy client) {
		rpsc = new RPSChallenge(client);
		rpsc.setVisible(true);
	}
	
	public void addUser(String id, String username) {
		rpsc.addClient(id);
		rpsc.setUsername(id, username);
	}
	
	public void removeUser(String id) {
		rpsc.removeClient(id);
	}
	
	public void setLocation(String id, int x, int y) {
		rpsc.move(id, x, y);
	}
	
	public void setDirection(String id, double rads) {
		rpsc.turn(id, rads);
	}
	
	public boolean displayChallenge(String id) {
		return rpsc.displayChallenge(id);
	}
	
	public void startGame() {
		rpsc.startGame();
	}
	
	public void cancelGame() {
		rpsc.cancelGame();
	}
	
	public void setOpponentShape(String shape) {
		rpsc.setShape(rpsc.getOpponentID(), shape);
	}
	
	public String getUserShape() {
		return rpsc.getUserShape();
	}
	
	public void revealWinner(boolean isWinner) {
		rpsc.showWinner(isWinner);
	}
	
	public void addChat(String message) {
		rpsc.addText(message);
	}
	
	public void setUsername(String id, String username) {
		rpsc.setUsername(id, username);
	}
	
	public void addHandShape(String name, String filepath) {
		rpsc.addHand(name, filepath);
	}
	
	public void setGameMessage(String message) {
		rpsc.setStatusText("$SYSTEM$:" + message);
	}
	
	public void setErrorMessage(String message) {
		rpsc.setStatusText("$ERROR$:" + message);
	}
	
	public void disableStatusTest() {
		rpsc.disableStatusText();
	}
	
	public void setPlayerStatus(String id, Status s) {
		rpsc.setStatus(id, s);
	}
	
	public void setPlayerStatus(Status s) {
		rpsc.setStatus(s);
	}
	
	public Status getPlayerStatus() {
		return rpsc.getStatus();
	}
	
	public void setWins(int wins) {
		rpsc.updateStats("Wins", wins);
	}
	
	public void setLosses(int losses) {
		rpsc.updateStats("Losses", losses);
	}
	
	public void setScore(int score) {
		rpsc.updateStats("Score", score);
	}
	
	public void addStat(String name, int defaultValue) {
		rpsc.addStat(name, defaultValue);
	}
	
	public void displayStats() {
		rpsc.displayStats();
	}
}
