/*
 * Decompiled with CFR 0.152.
 */
package ncp.ica.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import ncp.ica.ClientProxy;
import ncp.ica.Status;
import ncp.ica.ui.Avatar;
import ncp.ica.ui.AvatarInfo;
import ncp.ica.ui.GameChoice;
import ncp.ica.ui.GamePanel;
import ncp.ica.ui.LoginPanel;
import ncp.ica.ui.MapComponent;
import ncp.ica.ui.RequestPanel;

public class RPSChallenge
extends JFrame
implements AvatarInfo {
    private ClientProxy comms;
    private HashMap<String, Avatar> avatarMap = new HashMap();
    private Avatar me;
    private Avatar opponent;
    private String myShape;
    private ArrayList<GameChoice> choices = new ArrayList();
    private Object notifier = new Object();
    private boolean accepted = false;
    private boolean playing = false;
    private boolean loggedIn = false;
    private boolean disableStatus = false;
    private HashMap<String, Integer> stats = new HashMap();
    private JLabel statusLabel;
    private Component mainComp = new JPanel();
    private JComponent room = new MapComponent(this);
    private LoginPanel loginPanel;
    private GamePanel gamePanel;
    private AbstractAction upAction;
    private AbstractAction downAction;
    private AbstractAction leftAction;
    private AbstractAction rightAction;
    private AbstractAction rotLAction;
    private AbstractAction rotRAction;
    private AbstractAction challengeAction;
    private AbstractAction loginAction;
    private Random random = new Random();

    public RPSChallenge(ClientProxy proxy) {
        this();
        this.comms = proxy;
    }

    public RPSChallenge() {
        this.choices.add(new GameChoice("Paper", "paper.png"));
        this.choices.add(new GameChoice("Rock", "rock.png"));
        this.choices.add(new GameChoice("Scissors", "scissors.png"));
        this.statusLabel = new JLabel();
        this.statusLabel.setFocusable(false);
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(1));
        this.statusLabel.setAlignmentX(0.5f);
        this.upAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RPSChallenge.this.moveAvatar("up");
            }
        };
        this.downAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RPSChallenge.this.moveAvatar("down");
            }
        };
        this.leftAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RPSChallenge.this.moveAvatar("left");
            }
        };
        this.rightAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RPSChallenge.this.moveAvatar("right");
            }
        };
        this.rotLAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RPSChallenge.this.rotateAvatar("left");
            }
        };
        this.rotRAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RPSChallenge.this.rotateAvatar("right");
            }
        };
        this.challengeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RPSChallenge.this.opponent != null) {
                    RPSChallenge.this.setStatusText(String.valueOf(RPSChallenge.this.opponent.getName()) + " challenged!");
                    if (RPSChallenge.this.comms != null) {
                        RPSChallenge.this.comms.challenge(RPSChallenge.this.opponent.getID());
                    }
                }
            }
        };
        this.loginAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RPSChallenge.this.switchPanel(RPSChallenge.this.loginPanel);
            }
        };
        this.room.getInputMap().put(KeyStroke.getKeyStroke("KP_UP"), "moveUp");
        this.room.getInputMap().put(KeyStroke.getKeyStroke("UP"), "moveUp");
        this.room.getInputMap().put(KeyStroke.getKeyStroke("W"), "moveUp");
        this.room.getInputMap().put(KeyStroke.getKeyStroke("KP_DOWN"), "moveDown");
        this.room.getInputMap().put(KeyStroke.getKeyStroke("DOWN"), "moveDown");
        this.room.getInputMap().put(KeyStroke.getKeyStroke("S"), "moveDown");
        this.room.getInputMap().put(KeyStroke.getKeyStroke("KP_LEFT"), "moveLeft");
        this.room.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), "moveLeft");
        this.room.getInputMap().put(KeyStroke.getKeyStroke("A"), "moveLeft");
        this.room.getInputMap().put(KeyStroke.getKeyStroke("KP_RIGHT"), "moveRight");
        this.room.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), "moveRight");
        this.room.getInputMap().put(KeyStroke.getKeyStroke("D"), "moveRight");
        this.room.getInputMap().put(KeyStroke.getKeyStroke("Q"), "rotLeft");
        this.room.getInputMap().put(KeyStroke.getKeyStroke("E"), "rotRight");
        this.room.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "challenge");
        this.room.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "login");
        this.room.getActionMap().put("moveUp", this.upAction);
        this.room.getActionMap().put("moveDown", this.downAction);
        this.room.getActionMap().put("moveLeft", this.leftAction);
        this.room.getActionMap().put("moveRight", this.rightAction);
        this.room.getActionMap().put("rotLeft", this.rotLAction);
        this.room.getActionMap().put("rotRight", this.rotRAction);
        this.room.getActionMap().put("challenge", this.challengeAction);
        this.room.getActionMap().put("login", this.loginAction);
        String timeString = Long.toString(System.currentTimeMillis());
        this.me = new Avatar("Client" + timeString.substring(timeString.length() - 4));
        this.stats.put("Wins", 0);
        this.stats.put("Losses", 0);
        this.stats.put("Score", 0);
        int cX = (this.random.nextInt(72) + 1) * 5;
        int cY = (this.random.nextInt(52) + 1) * 5;
        this.me.setPosition(new Point(cX, cY));
        this.avatarMap.put(this.me.getID(), this.me);
        this.setLayout(new BorderLayout());
        this.loginPanel = new LoginPanel(this);
        this.switchPanel(this.loginPanel);
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BoxLayout(statusPanel, 1));
        statusPanel.add(this.statusLabel);
        statusPanel.add(Box.createVerticalStrut(10));
        this.statusLabel.setEnabled(false);
        this.add((Component)statusPanel, "South");
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setTitle("NCP ICA - RPC Challenge");
        this.room.setFocusable(true);
        this.room.setFocusCycleRoot(true);
    }

    private void switchPanel(Component panel) {
        this.remove(this.mainComp);
        this.mainComp = panel;
        panel.setPreferredSize(new Dimension(400, 300));
        this.add(panel, "Center");
        this.validate();
        this.mainComp.repaint();
        this.repaint();
    }

    private void rotateAvatar(String direction) {
        Double angle = this.me.getDirection();
        double true_angle = angle + Math.PI;
        if (direction.equals("left")) {
            true_angle += 0.12566370614359174;
            angle = (true_angle %= Math.PI * 2) + Math.PI;
        } else if (direction.equals("right")) {
            true_angle -= 0.12566370614359174;
            angle = (true_angle %= Math.PI * 2) + Math.PI;
        }
        if (this.comms != null) {
            this.comms.setDirection(true_angle);
        }
        this.me.setDirection(angle);
        this.repaint();
    }

    private void moveAvatar(String direction) {
        Point myPos = this.me.getPosition();
        if (direction.equals("up") && myPos.y >= 25) {
            myPos.move(myPos.x, myPos.y - 5);
        } else if (direction.equals("down") && myPos.y < 245) {
            myPos.move(myPos.x, myPos.y + 5);
        } else if (direction.equals("left") && myPos.x >= 25) {
            myPos.move(myPos.x - 5, myPos.y);
        } else if (direction.equals("right") && myPos.x < 350) {
            myPos.move(myPos.x + 5, myPos.y);
        }
        if (this.comms != null) {
            this.comms.moveChar(myPos.x, myPos.y);
        }
        this.repaint();
    }

    protected void loginUser(String username) {
        this.me.setName(username);
        if (this.comms != null) {
            if (!this.loggedIn) {
                this.comms.join(this.me.getID(), this.me.getName());
                this.loggedIn = true;
                this.comms.moveChar(this.me.getPosition().x, this.me.getPosition().y);
            } else {
                this.comms.changeName(username);
            }
        }
        this.switchPanel(this.room);
        this.loginPanel.reset();
        this.room.setFocusable(true);
        this.room.setFocusCycleRoot(true);
        this.room.requestFocusInWindow();
        this.setStatusText("Waiting for other users...");
    }

    protected void sendUserText(String text) {
        if (this.comms != null) {
            this.comms.sendChat(text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyClient(boolean result) {
        Object object = this.notifier;
        synchronized (object) {
            this.accepted = result;
            this.notifier.notifyAll();
        }
    }

    protected boolean updateable() {
        return !this.disableStatus;
    }

    protected boolean setMyShape(String shape) {
        this.myShape = shape;
        if (this.comms != null) {
            return this.comms.makeShape(shape);
        }
        return false;
    }

    @Override
    public HashMap<String, Integer> getStats() {
        return this.stats;
    }

    public ArrayList<String> canChallenge() {
        ArrayList<String> close = new ArrayList<String>();
        Point[] myBounds = MapComponent.getBounds(this.me.getPosition(), this.me.getDirection());
        for (Avatar avatar : this.getAvatars()) {
            Point[] bounds = MapComponent.getBounds(avatar.getPosition(), avatar.getDirection());
            if (!MapComponent.checkBounds(myBounds[1], bounds[0], 12.0) && !MapComponent.checkBounds(myBounds[2], bounds[0], 12.0) && !MapComponent.checkBounds(myBounds[3], bounds[0], 12.0)) continue;
            if (avatar != this.me) {
                close.add(avatar.getID());
            }
            this.opponent = avatar;
            if (!this.updateable()) continue;
            this.setStatusText("Challenge " + avatar.getName() + "? (Press Enter)");
        }
        if (close.size() == 0) {
            this.opponent = null;
            if (this.avatarMap.size() > 1) {
                if (this.updateable()) {
                    this.setStatusText("Find an opponent to challenge!");
                } else if (this.updateable()) {
                    this.setStatusText("Waiting for opponents...");
                }
            }
        }
        return close;
    }

    @Override
    public String getMyID() {
        return this.me.getID();
    }

    @Override
    public Collection<Avatar> getAvatars() {
        return this.avatarMap.values();
    }

    public void setStatusText(String text) {
        String dispText;
        String[] bits = text.split(":");
        if (bits.length > 1) {
            if (bits[0].equals("$ERROR$")) {
                this.statusLabel.setForeground(Color.RED);
            } else {
                this.statusLabel.setForeground(Color.BLACK);
            }
            dispText = bits[1];
        } else {
            this.statusLabel.setForeground(Color.BLACK);
            dispText = text;
        }
        this.statusLabel.setEnabled(true);
        this.statusLabel.setText(dispText);
    }

    public void disableStatusText() {
        this.disableStatus = true;
    }

    public void move(String clientID, int x, int y) {
        if (this.avatarMap.containsKey(clientID) && !clientID.equals(this.me.getID())) {
            this.avatarMap.get(clientID).setPosition(new Point(x, y));
            this.avatarMap.get(clientID).setStatus(Status.READY);
            this.repaint();
        }
    }

    public void turn(String clientID, Double dir) {
        if (this.avatarMap.containsKey(clientID) && !clientID.equals(this.me.getID())) {
            this.avatarMap.get(clientID).setDirection(dir - Math.PI);
            this.repaint();
        }
    }

    public void addClient(String clientID) {
        if (!this.avatarMap.containsKey(clientID)) {
            this.avatarMap.put(clientID, new Avatar(clientID));
            this.avatarMap.get(clientID).setStatus(Status.AWAY);
        } else {
            System.err.println("Error: Client ID already exists");
        }
    }

    public void removeClient(String clientID) {
        if (this.avatarMap.containsKey(clientID)) {
            this.avatarMap.remove(clientID);
        }
    }

    public void setUsername(String clientID, String username) {
        if (this.avatarMap.containsKey(clientID)) {
            this.avatarMap.get(clientID).setName(username);
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean displayChallenge(String opponentID) {
        if (this.avatarMap.containsKey(opponentID)) {
            this.switchPanel(new RequestPanel(this, this.avatarMap.get(opponentID)));
        }
        Object object = this.notifier;
        synchronized (object) {
            try {
                this.notifier.wait();
                if (this.accepted) {
                    this.opponent = this.avatarMap.get(opponentID);
                }
                System.out.println("Challenge status " + this.accepted);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.accepted;
    }

    public void showWinner(boolean hasWon) {
        if (this.playing) {
            this.gamePanel.revealOpponent(hasWon);
            if (hasWon) {
                if (this.updateable()) {
                    this.setStatusText("$SYSTEM$:You won!");
                } else if (this.updateable()) {
                    this.setStatusText("$SYSTEM$:" + this.opponent.getName() + " won!");
                }
            }
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    RPSChallenge.this.switchPanel(RPSChallenge.this.room);
                    RPSChallenge.this.room.requestFocusInWindow();
                }
            }, 5000L);
        }
    }

    public void startGame() {
        if (this.opponent != null) {
            this.gamePanel = new GamePanel(this, this.opponent, this.choices);
            this.switchPanel(this.gamePanel);
            this.playing = true;
            this.setStatusText("$SYSTEM$:Game started against " + this.opponent.getName() + ". Choose your Shape!");
        } else {
            this.setStatusText("$ERROR$:No opponent to start game with.");
        }
    }

    public void cancelGame() {
        if (this.updateable()) {
            this.setStatusText("$SYSTEM$:Challenge failed. Returning to game room...");
        }
        this.notifyClient(false);
        this.switchPanel(this.room);
        this.room.requestFocusInWindow();
    }

    public void addHand(String handName, String filepath) {
        this.choices.add(new GameChoice(handName, filepath));
    }

    public void setShape(String id, String shape) {
        if (this.playing && this.opponent.getID().equals(id)) {
            this.gamePanel.setOpponentShape(shape);
        }
    }

    public String getUserShape() {
        return this.myShape;
    }

    public String getOpponentID() {
        if (this.opponent != null) {
            return this.opponent.getID();
        }
        return "";
    }

    public void addText(String msg) {
        if (this.playing && this.gamePanel != null) {
            this.gamePanel.addUserText(this.opponent.getName(), msg);
        }
    }

    public void setStatus(String id, Status s) {
        if (this.avatarMap.keySet().contains(id)) {
            this.avatarMap.get(id).setStatus(s);
        } else {
            System.err.println("Player ID: " + id + "not found");
        }
    }

    public void setStatus(Status s) {
        this.me.setStatus(s);
    }

    public Status getStatus() {
        return this.me.getStatus();
    }

    public void addStat(String statName, int defaultVal) {
        this.stats.put(statName, defaultVal);
    }

    public void updateStats(String stat, int value) {
        if (this.stats.containsKey(stat)) {
            this.stats.put(stat, value);
            if (this.stats.get("Wins") - this.stats.get("Losses") > 0) {
                this.me.setWinning(true);
            } else {
                this.me.setWinning(false);
            }
        } else {
            System.err.println("Stat not found: " + stat);
        }
    }

    public void displayStats() {
        ((MapComponent)this.room).toggleStats();
    }

    public static void main(String[] args) {
        RPSChallenge rps = new RPSChallenge();
        rps.setVisible(true);
        rps.addClient("Alice");
        rps.setUsername("Alice", "Alice");
        rps.move("Alice", 20, 20);
        rps.addClient("Bob");
        rps.setUsername("Bob", "Bob");
        rps.move("Bob", 200, 200);
        rps.displayStats();
        while (true) {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            try {
                String test = br.readLine();
                String[] ins = test.split(" ");
                int cfr_ignored_0 = ins.length;
            }
            catch (IOException e) {
                System.err.println("I/O error on Standard in/out");
                return;
            }
        }
    }
}

