/*
 * Decompiled with CFR 0.152.
 */
package ncp.ica.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JComponent;
import ncp.ica.Status;
import ncp.ica.ui.Avatar;
import ncp.ica.ui.AvatarInfo;

public class MapComponent
extends JComponent {
    private static final long serialVersionUID = 1L;
    private AvatarInfo info;
    private boolean displayStats = false;
    public static final int MAP_WIDTH = 400;
    public static final int MAP_HEIGHT = 300;
    public static final int AVATAR_SIZE = 25;
    public static final int MOVE_INTERVAL = 5;
    public static final int Y_MAX = 245;
    public static final int Y_MIN = 25;
    public static final int X_MAX = 350;
    public static final int X_MIN = 25;

    public MapComponent(AvatarInfo info) {
        this.info = info;
    }

    public void toggleStats() {
        this.displayStats = !this.displayStats;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Font font = new Font("Serif", 0, 11);
        Font ifont = new Font("Serif", 2, 11);
        g.setFont(font);
        FontRenderContext frc = ((Graphics2D)g).getFontRenderContext();
        Collection<String> close = this.info.canChallenge();
        for (Avatar avatar : this.info.getAvatars()) {
            int wX;
            Point pos = avatar.getPosition();
            Rectangle2D textBounds = font.getStringBounds(avatar.getName(), frc);
            if (avatar.getID().equals(this.info.getMyID())) {
                g.setColor(Color.RED);
            }
            if (close.contains(avatar.getID())) {
                g.setColor(Color.BLUE);
            }
            if (this.displayStats && avatar.isWinning()) {
                g.setColor(Color.GREEN);
            }
            int rX = 12 - (int)textBounds.getWidth() / 2;
            int rY = (int)textBounds.getHeight();
            g2.draw(new Ellipse2D.Double(pos.x, pos.y, 25.0, 25.0));
            Point[] bounds = MapComponent.getBounds(avatar.getPosition(), avatar.getDirection());
            GeneralPath dirView = new GeneralPath(0, 2);
            dirView.moveTo(bounds[0].x, bounds[0].y);
            dirView.lineTo(bounds[1].x, bounds[1].y);
            dirView.lineTo(bounds[2].x, bounds[2].y);
            dirView.closePath();
            g2.draw(dirView);
            g2.fill(dirView);
            g.setColor(Color.BLACK);
            g2.setFont(font);
            if (avatar.getStatus() != Status.READY) {
                g2.setFont(ifont);
            }
            String extraText = "";
            if (avatar.getStatus() == Status.PLAYING) {
                extraText = " <playing>";
            }
            if (avatar.getStatus() == Status.WAITING) {
                extraText = " <waiting>";
            }
            if (avatar.getStatus() == Status.ERROR) {
                g2.setColor(Color.RED);
            }
            if (this.displayStats && avatar.isWinning()) {
                wX = 12 - (int)font.getStringBounds("WINNER", frc).getWidth() / 2;
                g2.drawString("WINNER", pos.x + wX, pos.y + rY - 25);
            }
            g2.drawString(avatar.getName(), pos.x + rX, pos.y + rY + 25);
            if (extraText.equals("")) continue;
            wX = 12 - (int)font.getStringBounds(extraText, frc).getWidth() / 2;
            g2.drawString(extraText, pos.x + wX, pos.y + rY + 25 + g2.getFontMetrics().getHeight());
        }
        if (this.displayStats) {
            this.drawStats(g);
        }
    }

    private void drawStats(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Point basePos = new Point(0, 0);
        int incVal = 0;
        HashMap<String, Integer> stats = this.info.getStats();
        g2.setFont(new Font("Serif", 0, 14));
        g2.setColor(Color.DARK_GRAY);
        for (String stat : stats.keySet()) {
            int xInc = 7 * g2.getFontMetrics().charWidth('m');
            g2.drawString(" " + stat + ": ", basePos.x, basePos.y + (incVal += g2.getFontMetrics().getHeight()));
            g2.drawString(stats.get(stat).toString(), basePos.x + xInc, basePos.y + incVal);
        }
    }

    public static Point[] getBounds(Point location, Double direction) {
        Point center;
        Point[] bounds = new Point[4];
        bounds[0] = center = new Point(location.x + 12, location.y + 12);
        int ly = (int)((double)center.y + 25.0 * Math.cos(direction + 0.25));
        int lx = (int)((double)center.x + 25.0 * Math.sin(direction + 0.25));
        int ry = (int)((double)center.y + 25.0 * Math.cos(direction - 0.25));
        int rx = (int)((double)center.x + 25.0 * Math.sin(direction - 0.25));
        bounds[1] = new Point(lx, ly);
        bounds[2] = new Point(rx, ry);
        int tx = (lx + rx) / 2;
        int ty = (ly + ry) / 2;
        bounds[3] = new Point(tx, ty);
        return bounds;
    }

    public static boolean checkBounds(Point a, Point b, double distance) {
        return Math.sqrt((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y)) < distance;
    }
}

