/*
 * Decompiled with CFR 0.152.
 */
package ncp.ica.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import ncp.ica.ui.Avatar;
import ncp.ica.ui.GameChoice;
import ncp.ica.ui.RPSChallenge;

public class GamePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    RPSChallenge mainFrame;
    JButton jb1;
    JButton jb;
    JTextField chatBox;
    JTextPane chatPane;
    GameChoice opponentChoice;
    JLabel hlabel;
    JLabel mlabel;
    private Style userStyle;
    private Style remoteStyle;
    private StyledDocument doc;
    HashMap<String, GameChoice> choiceMap = new HashMap();

    public GamePanel(RPSChallenge main, Avatar opponent, Collection<GameChoice> choices) {
        this.mainFrame = main;
        ImageIcon iconh = new ImageIcon(ClassLoader.getSystemResource("hand.png"));
        this.hlabel = new JLabel(iconh);
        this.hlabel.setPreferredSize(new Dimension(80, 100));
        this.hlabel.setAlignmentX(0.5f);
        JPanel lpanel = new JPanel();
        lpanel.setLayout(new BoxLayout(lpanel, 1));
        JLabel llabel = new JLabel("YOU");
        llabel.setFont(llabel.getFont().deriveFont(20.0f));
        llabel.setAlignmentX(0.5f);
        lpanel.add(llabel);
        lpanel.add(this.hlabel);
        lpanel.setAlignmentY(0.5f);
        this.mlabel = new JLabel(iconh);
        this.mlabel.setPreferredSize(new Dimension(80, 100));
        this.mlabel.setAlignmentX(0.5f);
        JPanel rpanel = new JPanel();
        rpanel.setLayout(new BoxLayout(rpanel, 1));
        JLabel rlabel = new JLabel(opponent.getName().toUpperCase());
        rlabel.setFont(rlabel.getFont().deriveFont(20.0f));
        rlabel.setAlignmentX(0.5f);
        rpanel.add(rlabel);
        rpanel.add(this.mlabel);
        rpanel.setAlignmentY(0.5f);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        mainPanel.add(Box.createHorizontalGlue());
        mainPanel.add(lpanel);
        mainPanel.add(Box.createHorizontalStrut(20));
        mainPanel.add(rpanel);
        mainPanel.add(Box.createHorizontalGlue());
        JPanel bpanel = new JPanel();
        bpanel.setPreferredSize(new Dimension(200, bpanel.getMaximumSize().height));
        bpanel.setLayout(new BoxLayout(bpanel, 1));
        for (GameChoice choice : choices) {
            this.choiceMap.put(choice.getName(), choice);
            choice.setAlignmentX(0.5f);
            choice.setEnabled(true);
            ActionListener[] actionListenerArray = choice.getActionListeners();
            int n = actionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionListener al = actionListenerArray[n2];
                choice.removeActionListener(al);
                ++n2;
            }
            choice.addActionListener(new ButtonListener(this));
            bpanel.add(choice);
        }
        mainPanel.setAlignmentX(0.5f);
        bpanel.setAlignmentX(0.5f);
        JPanel xpanel = new JPanel();
        xpanel.add(Box.createVerticalStrut(10));
        xpanel.setLayout(new BoxLayout(xpanel, 1));
        xpanel.add(mainPanel);
        xpanel.add(Box.createVerticalStrut(10));
        xpanel.add(bpanel);
        this.setLayout(new BorderLayout());
        this.add((Component)xpanel, "Center");
        this.chatPane = new JTextPane();
        JScrollPane scrollPane = new JScrollPane(this.chatPane);
        JPanel chatPanel = new JPanel();
        chatPanel.setPreferredSize(new Dimension(200, 300));
        chatPanel.setLayout(new BorderLayout());
        chatPanel.add((Component)scrollPane, "Center");
        this.chatBox = new JTextField();
        this.chatBox.addActionListener(new ChatListener());
        chatPanel.add((Component)this.chatBox, "South");
        this.add((Component)chatPanel, "East");
        this.chatPane.setFocusable(false);
        this.doc = this.chatPane.getStyledDocument();
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        StyleConstants.setFontFamily(def, "SansSerif");
        this.remoteStyle = this.doc.addStyle("remote", def);
        StyleConstants.setForeground(this.remoteStyle, Color.BLUE);
        this.userStyle = this.doc.addStyle("user", def);
        StyleConstants.setItalic(this.userStyle, true);
    }

    protected void addUserText(String name, String text) {
        Style outStyle = this.remoteStyle;
        if (name.equals("Me")) {
            outStyle = this.userStyle;
        }
        String outText = String.valueOf(name) + ": " + text + "\n";
        try {
            this.doc.insertString(this.doc.getLength(), outText, outStyle);
        }
        catch (BadLocationException e) {
            System.err.println("Chat Pane Error");
        }
    }

    protected void setChoice(GameChoice choice) {
        this.hlabel.setIcon(choice.getChoiceIcon());
        boolean fixed = this.mainFrame.setMyShape(choice.getName());
        for (GameChoice c : this.choiceMap.values()) {
            c.setEnabled(fixed);
        }
    }

    public void setOpponentShape(String shape) {
        if (this.choiceMap.containsKey(shape)) {
            this.opponentChoice = this.choiceMap.get(shape);
        }
    }

    public void revealOpponent(boolean hasWon) {
        this.mlabel.setIcon(this.opponentChoice.getChoiceIcon());
    }

    private class ButtonListener
    implements ActionListener {
        private GamePanel panel;

        public ButtonListener(GamePanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getActionCommand().equals("SELECT") && ((GameChoice)ae.getSource()).isEnabled()) {
                GamePanel.this.setChoice((GameChoice)ae.getSource());
            }
        }
    }

    private class ChatListener
    implements ActionListener {
        private ChatListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String text = GamePanel.this.chatBox.getText();
            if (!text.equals("")) {
                GamePanel.this.addUserText("Me", text);
                GamePanel.this.mainFrame.sendUserText(text);
                GamePanel.this.chatBox.setText("");
            }
        }
    }
}

